import React, { useState, useEffect } from "react";
import TapButton from "../components/TapButton";
import CardStat from "../components/CardStat";
import { toast } from "react-toastify";

export default function Tap() {
  const [points, setPoints] = useState(0);
  const [tapCount, setTapCount] = useState(0);
  const [loading, setLoading] = useState(false);
  const [bonusPoint, setBonusPoint] = useState(1000);
  const [targetTap, setTargetTap] = useState(100);

  useEffect(() => {
    fetch("/backend/user.php")
      .then(res => res.json())
      .then(data => {
        setPoints(data.points);
        setTapCount(data.tap_count);
      });
    fetch("/backend/setting.php?key=rate")
      .then(res => res.text())
      .then(rate => {
        if (rate) {
          const [tap, bonus] = rate.split(":").map(Number);
          setTargetTap(tap);
          setBonusPoint(bonus);
        }
      });
  }, []);

  const handleTap = () => {
    setLoading(true);
    fetch("/backend/tap.php", { method: "POST", credentials: "include" })
      .then(res => res.json())
      .then(data => {
        setLoading(false);
        if (data.ok) {
          setPoints(data.points);
          setTapCount(data.tap_count);
        } else {
          toast.error("Gagal tap!");
        }
      });
  };

  return (
    <div className="max-w-lg mx-auto mt-10 flex flex-col items-center">
      <CardStat label="Poin Kamu" value={points} className="mb-6" />
      <div className="text-lg text-orange-500 font-bold mb-4">
        Kamu sudah tap <span className="text-blue-600">{tapCount}</span> kali.<br />
        Tap <span className="text-blue-600">{targetTap - (tapCount % targetTap)}</span> kali lagi untuk dapat bonus <span className="text-green-600">{bonusPoint} poin</span>!
      </div>
      <TapButton onTap={handleTap} loading={loading} />
    </div>
  );
}