CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) UNIQUE,
  password VARCHAR(128),
  points INT DEFAULT 0,
  tap_count INT DEFAULT 0,
  saldo INT DEFAULT 0,
  registered DATETIME DEFAULT CURRENT_TIMESTAMP,
  banned TINYINT(1) DEFAULT 0
);

CREATE TABLE tap_logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  created DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE redeem_logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  points INT,
  saldo INT,
  created DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE withdraws (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  saldo INT,
  status ENUM('pending','approved','declined') DEFAULT 'pending',
  created DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE settings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(50) UNIQUE,
  value TEXT
);

CREATE TABLE admins (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) UNIQUE,
  password VARCHAR(128)
);

INSERT INTO admins(username,password) VALUES ('admin', MD5('admin123'));
